/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sihenzhang.crockpot.block.CrockPotBlock;
import com.sihenzhang.crockpot.integration.jei.ModIntegrationJei;
import com.sihenzhang.crockpot.integration.jei.gui.requirement.AbstractDrawableRequirement;
import com.sihenzhang.crockpot.recipe.cooking.CrockPotCookingRecipe;
import com.sihenzhang.crockpot.recipe.cooking.requirement.IRequirement;
import com.sihenzhang.crockpot.tag.CrockPotBlockTags;
import com.sihenzhang.crockpot.util.I18nUtils;
import com.sihenzhang.crockpot.util.RLUtils;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class CrockPotCookingRecipeCategory
implements IRecipeCategory<CrockPotCookingRecipe> {
    public static final RecipeType<CrockPotCookingRecipe> RECIPE_TYPE = RecipeType.create((String)"crockpot", (String)"crock_pot_cooking", CrockPotCookingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable priority;
    private final IDrawable time;
    private final LoadingCache<CrockPotCookingRecipe, List<AbstractDrawableRequirement<? extends IRequirement>>> cachedDrawables;

    public CrockPotCookingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation recipeGui = RLUtils.createRL("textures/gui/jei/crock_pot_cooking.png");
        this.background = guiHelper.createDrawable(recipeGui, 0, 0, 176, 133);
        this.icon = guiHelper.createDrawable(ModIntegrationJei.ICONS, 80, 0, 16, 16);
        this.priority = guiHelper.createDrawable(recipeGui, 176, 0, 16, 16);
        this.time = guiHelper.createDrawable(recipeGui, 176, 16, 16, 16);
        this.cachedDrawables = CacheBuilder.newBuilder().maximumSize(32L).build((CacheLoader)new CacheLoader<CrockPotCookingRecipe, List<AbstractDrawableRequirement<? extends IRequirement>>>(){

            public List<AbstractDrawableRequirement<? extends IRequirement>> load(CrockPotCookingRecipe key) {
                return AbstractDrawableRequirement.getDrawables(key.getRequirements());
            }
        });
    }

    public RecipeType<CrockPotCookingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return I18nUtils.createIntegrationComponent("jei", "crock_pot_cooking");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrockPotCookingRecipe recipe, IFocusGroup focuses) {
        int xOffset = 2;
        int yOffset = 2;
        int maxWidth = 0;
        List drawables = (List)this.cachedDrawables.getUnchecked((Object)recipe);
        for (AbstractDrawableRequirement drawable : drawables) {
            List<ItemStack> invisibleInputs = drawable.getInvisibleInputs();
            if (!invisibleInputs.isEmpty()) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(invisibleInputs);
            }
            if (yOffset != 2 && yOffset + drawable.getHeight() > 96) {
                xOffset += maxWidth + 2;
                yOffset = 2;
                maxWidth = 0;
            }
            List<AbstractDrawableRequirement.GuiItemStacksInfo> guiItemStacksInfos = drawable.getGuiItemStacksInfos(xOffset, yOffset);
            guiItemStacksInfos.forEach(guiItemStacksInfo -> builder.addSlot(guiItemStacksInfo.role, guiItemStacksInfo.x, guiItemStacksInfo.y).addItemStacks(guiItemStacksInfo.stacks));
            maxWidth = Math.max(drawable.getWidth(), maxWidth);
            yOffset += drawable.getHeight() + 2;
        }
        List<ItemStack> pots = ForgeRegistries.BLOCKS.tags().getTag(CrockPotBlockTags.CROCK_POTS).stream().filter(CrockPotBlock.class::isInstance).map(CrockPotBlock.class::cast).filter(pot -> pot.getPotLevel() >= recipe.getPotLevel()).map(block -> block.m_5456_().m_7968_()).toList();
        builder.addSlot(RecipeIngredientRole.CATALYST, 62, 104).addItemStacks(pots);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 104, 110).addItemStack(recipe.getResult());
    }

    public void draw(CrockPotCookingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int cookingTime = recipe.getCookingTime();
        if (cookingTime > 0) {
            this.time.draw(guiGraphics, 0, 117);
            guiGraphics.m_280614_(font, (Component)I18nUtils.createIntegrationComponent("jei", "crock_pot_cooking.cooking_time.second", cookingTime / 20), 17, 121, -8355712, false);
        }
        String priorityString = String.valueOf(recipe.getPriority());
        int priorityWidth = font.m_92895_(priorityString);
        this.priority.draw(guiGraphics, 159 - priorityWidth, 117);
        guiGraphics.m_280056_(font, priorityString, 175 - priorityWidth, 121, -8355712, false);
        int xOffset = 2;
        int yOffset = 2;
        int maxWidth = 0;
        List drawables = (List)this.cachedDrawables.getUnchecked((Object)recipe);
        for (AbstractDrawableRequirement drawable : drawables) {
            if (yOffset != 2 && yOffset + drawable.getHeight() > 96) {
                xOffset += maxWidth + 2;
                yOffset = 2;
                maxWidth = 0;
            }
            drawable.draw(guiGraphics, xOffset, yOffset);
            maxWidth = Math.max(drawable.getWidth(), maxWidth);
            yOffset += drawable.getHeight() + 2;
        }
    }

    public List<Component> getTooltipStrings(CrockPotCookingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 0.0 && mouseX <= 16.0 && mouseY >= 117.0 && mouseY <= 133.0) {
            return List.of(I18nUtils.createIntegrationComponent("jei", "crock_pot_cooking.cooking_time"));
        }
        String priorityString = String.valueOf(recipe.getPriority());
        int priorityWidth = Minecraft.m_91087_().f_91062_.m_92895_(priorityString);
        if (mouseX >= 159.0 - (double)priorityWidth && mouseX <= 175.0 - (double)priorityWidth && mouseY >= 117.0 && mouseY <= 133.0) {
            return List.of(I18nUtils.createIntegrationComponent("jei", "crock_pot_cooking.priority"));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }
}

